EvaluateScript("Globals.js");

function Debug(what_to_debug)       // For debugging!
{
  if (AreKeysLeft()){ GetKey(); }
  GetSystemFont().drawText (10, 10, what_to_debug);
  FlipScreen();
  GetKey();
}

function game ()
{   
  Intro();
  Create_Items();
  Create_Equipment();
  Create_Players();
  New_Game();   
}

var Keys = new Object;
Keys.Accept = KEY_CTRL;
Keys.Cancel = KEY_ALT;
Keys.Menu = KEY_ESCAPE;

function Intro ()
{ 
  while (IsKeyPressed(Keys.Accept) == false)
  {
    Text(10,20,   "                    Project Pheonix");
    Text(10,35,   "        By Jake F. of Joquan Games Studios");
    Text(10,45,   " ");
    Text(10,55,   "           Keys:");
    Text(10,65,   "             Accept Key = Ctrl.");
    Text(10,75,   "             Cancel Key = Alt.");
    Text(10,85,   "             Menu Key = Escape");
    Text(10,95,   " ");
    Text(10,105, " ");
    Text(10,115, "          ::Press Ctrl to continue::");
    FlipScreen();
  }
}

function New_Game () 
{   
  BindKey (Keys.Menu, 'Game_Menu()', 't()');
  CreatePerson ("Ilxder", "ildxer male with sword.rss", false);
  AttachCamera ("Ilxder");
  AttachInput ("Ilxder");
  SetTalkActivationKey (Keys.Accept);
  SetRenderScript("RenderScript();");  
  MapEngine ("dungeon1.rmp", 60);
  UnbindKey (Keys.Menu);
}

function RenderScript()
{
  UpdatePersonIdleAnimations(); 
  UpdateEmotions(); 
  UpdateTextBox();
}

function Warp(x, y, layer, map) {  // Moves the character from one place to another.
  var person = GetInputPerson();
  if (map) ChangeMap(map);
  if (layer >= 0) SetPersonLayer(person, layer);
    FadeOut(1000);
    SetPersonX(person, x);
    SetPersonY(person, y);
    UpdateMapEngine();
    RenderMap();
    FadeIn(1000);
}

var font = GetSystemFont();
var port = 1833;
var data = ListenOnPort(port);

while (!data.isConnected())
{
  if (IsKeyPressed(KEY_ESCAPE))
    break;
  font.drawText(0, 0, "Connecting to Bug Watch System...");
  FlipScreen();
}

if(data.isConnected()) 
{
  // send a hello message
  data.write(CreateByteArrayFromString("hello: Hi, you've connected to " + GetLocalAddress()));
}